import java.util.concurrent.*;

class PublisherDemo {
	public static void main(String[] args) throws InterruptedException {
		var publisher = new SubmissionPublisher<Integer>();

		publisher.subscribe(new DemoSubscriber());

		System.out.println("Die Produktion beginnt.");
		for (int i = 1; i <= 5; i++) {
//			while (publisher.estimateMaximumLag() > 0) { // Unkonsumierte Produkte vorhanden,
//				// andere Arbeiten erledigen
//				Thread.sleep(100);
//			}
			publisher.submit(i);
		}

		publisher.close();
		System.out.println("Der Publisher ist geschlossen.");

		// Der Common Pool erhält Zeit, um begonnene Aufgaben zu erledigen:
		ForkJoinPool.commonPool().awaitQuiescence(10, TimeUnit.SECONDS);
	}
}
